/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.featurediscovery.service;

import com.atlassian.confluence.plugins.featurediscovery.manager.DiscoveredFeatureManager;
import com.atlassian.confluence.plugins.featurediscovery.service.PluginFeaturesService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;

public class DefaultPluginFeaturesService
implements PluginFeaturesService {
    private final DiscoveredFeatureManager discoveredFeatureManager;
    private final Plugin plugin;

    public DefaultPluginFeaturesService(DiscoveredFeatureManager discoveredFeatureManager, Plugin plugin) {
        this.discoveredFeatureManager = discoveredFeatureManager;
        this.plugin = plugin;
    }

    @Override
    public boolean isDiscovered(ConfluenceUser user, String featureKey) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)featureKey);
        return this.discoveredFeatureManager.find(this.plugin.getKey(), featureKey, user.getKey().getStringValue()) != null;
    }

    @Override
    public void markDiscovered(ConfluenceUser user, String featureKey) {
        if (this.discoveredFeatureManager.find(this.plugin.getKey(), featureKey, user.getKey().getStringValue()) == null) {
            this.discoveredFeatureManager.create(this.plugin.getKey(), featureKey, user.getKey().getStringValue(), new Date());
        }
    }

    @Override
    public void markUndiscovered(@Nonnull ConfluenceUser user, @Nonnull String featureKey) {
        this.discoveredFeatureManager.delete(this.plugin.getKey(), featureKey, user.getKey().getStringValue());
    }
}

