/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.featurediscovery.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.featurediscovery.entity.DiscoveredFeatureAo;
import com.atlassian.confluence.plugins.featurediscovery.manager.DiscoveredFeatureManager;
import com.atlassian.confluence.plugins.featurediscovery.model.DiscoveredFeature;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DefaultDiscoveredFeatureManager
implements DiscoveredFeatureManager {
    private static final Function<DiscoveredFeatureAo, DiscoveredFeature> ENTITY_MAPPER = new Function<DiscoveredFeatureAo, DiscoveredFeature>(){

        public DiscoveredFeature apply(DiscoveredFeatureAo input) {
            return new DiscoveredFeature(input.getPluginKey(), input.getKey(), input.getUserKey(), input.getDate());
        }
    };
    private final ActiveObjects ao;

    public DefaultDiscoveredFeatureManager(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public DiscoveredFeature find(String pluginKey, String featureKey, String userKey) {
        DiscoveredFeatureAo entity = this.findEntity(pluginKey, featureKey, userKey);
        return entity != null ? (DiscoveredFeature)ENTITY_MAPPER.apply((Object)entity) : null;
    }

    @Override
    public DiscoveredFeature create(String pluginKey, String featureKey, String userKey, Date date) {
        DiscoveredFeatureAo newEntity = (DiscoveredFeatureAo)this.ao.create(DiscoveredFeatureAo.class, new DBParam[0]);
        newEntity.setPluginKey(pluginKey);
        newEntity.setKey(featureKey);
        newEntity.setUserKey(userKey);
        newEntity.setDate(date);
        newEntity.save();
        return (DiscoveredFeature)ENTITY_MAPPER.apply((Object)newEntity);
    }

    @Override
    public void delete(String pluginKey, String featureKey, String userKey) {
        DiscoveredFeatureAo entity = this.findEntity(pluginKey, featureKey, userKey);
        if (entity != null) {
            this.ao.delete(new RawEntity[]{entity});
        }
    }

    @Override
    public List<DiscoveredFeature> listForUser(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey});
        Object[] features = (DiscoveredFeatureAo[])this.ao.find(DiscoveredFeatureAo.class, query);
        return Lists.transform((List)ImmutableList.copyOf((Object[])features), ENTITY_MAPPER);
    }

    private DiscoveredFeatureAo findEntity(String pluginKey, String featureKey, String userKey) {
        DiscoveredFeatureAo[] result = (DiscoveredFeatureAo[])this.ao.find(DiscoveredFeatureAo.class, Query.select().where("PLUGIN_KEY = ? AND KEY = ? AND USER_KEY = ?", new Object[]{pluginKey, featureKey, userKey}));
        return result.length > 0 ? result[0] : null;
    }
}

