/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.expand;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.StreamableMacroAdapter;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class ExpandMacro
extends StreamableMacroAdapter {
    private static final String SOY_TEMPLATE_MODULE = "com.atlassian.confluence.plugins.expand-macro:expand-macro-soy-templates";
    private final I18nResolver i18nResolver;
    private final PageBuilderService pageBuilderService;
    private final TemplateRenderer templateRenderer;

    public ExpandMacro(I18nResolver i18nResolver, PageBuilderService pageBuilderService, TemplateRenderer templateRenderer) {
        this.i18nResolver = i18nResolver;
        this.pageBuilderService = pageBuilderService;
        this.templateRenderer = templateRenderer;
    }

    public Streamable executeToStream(Map<String, String> parameters, Streamable body, ConversionContext context) {
        boolean forMobile = ExpandMacro.isForMobile(context);
        boolean forDynamicDisplay = ExpandMacro.isForDynamicDisplay(context);
        RequiredResources requiredResources = this.pageBuilderService.assembler().resources();
        requiredResources.requireContext(forMobile ? "atl.confluence.macros.expand.mobile" : "atl.confluence.macros.expand.desktop");
        String defaultTitleKey = forMobile ? "expand-macro.mobile.default-title" : "expand-macro.default-title";
        ImmutableMap templateModel = ImmutableMap.of((Object)"title", (Object)this.getTitle(parameters, defaultTitleKey), (Object)"toggleId", (Object)this.getToggleId());
        if (!forDynamicDisplay) {
            requiredResources.requireWebResource("com.atlassian.confluence.plugins.expand-macro:expand-macro-css-only");
        }
        final String beforeTemplateName = forDynamicDisplay ? "Confluence.ExpandMacro.dynamicBefore.soy" : "Confluence.ExpandMacro.staticBefore.soy";
        String afterTemplateName = "Confluence.ExpandMacro.after.soy";
        return new Streamable((Map)templateModel, body){
            final /* synthetic */ Map val$templateModel;
            final /* synthetic */ Streamable val$body;
            {
                this.val$templateModel = map;
                this.val$body = streamable;
            }

            public void writeTo(Writer writer) throws IOException {
                ExpandMacro.this.templateRenderer.renderTo((Appendable)writer, ExpandMacro.SOY_TEMPLATE_MODULE, beforeTemplateName, this.val$templateModel);
                this.val$body.writeTo(writer);
                ExpandMacro.this.templateRenderer.renderTo((Appendable)writer, ExpandMacro.SOY_TEMPLATE_MODULE, "Confluence.ExpandMacro.after.soy", this.val$templateModel);
            }
        };
    }

    private static boolean isForMobile(ConversionContext context) {
        return "mobile".equals(context.getOutputDeviceType());
    }

    private static boolean isForDynamicDisplay(ConversionContext context) {
        return Sets.newHashSet((Object[])new String[]{"display", "preview"}).contains(context.getOutputType());
    }

    private String getTitle(Map<String, String> parameters, String defaultTitleKey) {
        if (parameters.containsKey("title")) {
            return parameters.get("title");
        }
        if (parameters.containsKey("0")) {
            return parameters.get("0");
        }
        return this.i18nResolver.getText(defaultTitleKey);
    }

    private String getToggleId() {
        return String.valueOf((int)(Math.random() * 2.147483647E9));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

