(function ($) {

    var unMungeEmailAddress = function (mungedEmail) {
        var parts = mungedEmail.split(',');

        return parts[0] + '@' + parts[1];
    };

    var launchEmailToPageDialog = function () {
        var dialog = new AJS.Dialog({
            width:840,
            height:500,
            id:"email-to-confluence-dialog",
            closeOnOutsideClick:false});

        var emailToPageAddress = $("meta[name='email-to-page-address']").attr('content'),
                configurationRequired = false;

        if (emailToPageAddress) {
            emailToPageAddress = unMungeEmailAddress(emailToPageAddress);
        }
        else {
            configurationRequired = true;
        }

        dialog.addHeader(AJS.I18n.getText("email.to.page.dialog.header"));
        dialog.addPanel("SinglePanel", Confluence.Templates.EmailToPage.dialogContent({
            emailToPageAddress:emailToPageAddress,
            configurationRequired:configurationRequired,
            configurationUrl:AJS.contextPath() + '/admin/mail/createmailserver.action?protocol=pop'
        }), "singlePanel");

        dialog.addButton(AJS.I18n.getText("dialog.back.button"), function (dialog) {
            //Close this dialog to show the create dialog
            dialog.remove();
        });

        dialog.show();
    };

    $(function () {
        $('a[href="' + AJS.contextPath() + '/admin/emailtoconfluence.action"]').click(function () {
            launchEmailToPageDialog();
            return false;
        });

        Confluence.Blueprint.register('com.atlassian.confluence.plugins.confluence-email-to-page:create-email-to-page',
                launchEmailToPageDialog);
    });

}(jQuery));