/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailtopage;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.plugins.emailgateway.api.EmailToContentConverter;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadAdminService;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmationAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ConfirmationAction.class);
    private StagedEmailThreadAdminService emailThreadConverterService;
    private String hash;
    private String pageId;
    private Exception validationException;
    private EmailToContentConverter<? extends ContentEntityObject> emailToPageConverter;

    public String doConfirm() throws Exception {
        StagedEmailThreadKey key = new StagedEmailThreadKey(this.hash);
        try {
            ContentEntityObject newPage = this.emailThreadConverterService.convertAndPublishStagedEmailThread(key, this.messageHolder, this.emailToPageConverter);
            this.pageId = newPage.getIdAsString();
            return "success";
        }
        catch (NotValidException e) {
            this.validationException = e;
            log.warn("Couldn't complete email-to-page creation, probably because page already exists: " + e.getMessage());
            return "input";
        }
        catch (IllegalArgumentException e) {
            log.warn("Couldn't complete email-to-page creation, probably because staged email has been deleted: " + e.getMessage());
            this.validationException = e;
            return "input";
        }
    }

    public String doReject() throws Exception {
        this.emailThreadConverterService.deleteStagedEmailThread(new StagedEmailThreadKey(this.hash));
        return "success";
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setEmailToPageConverter(EmailToContentConverter<? extends ContentEntityObject> emailToPageConverter) {
        this.emailToPageConverter = emailToPageConverter;
    }

    public void setEmailThreadConverterService(StagedEmailThreadAdminService emailThreadConverterService) {
        this.emailThreadConverterService = emailThreadConverterService;
    }

    public Exception getValidationException() {
        return this.validationException;
    }
}

