/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailtopage;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.emailgateway.api.ConfirmationNotificationSender;
import com.atlassian.confluence.plugins.emailgateway.api.EmailHandlingException;
import com.atlassian.confluence.plugins.emailgateway.api.EmailStagingException;
import com.atlassian.confluence.plugins.emailgateway.api.EmailStagingService;
import com.atlassian.confluence.plugins.emailgateway.api.EmailToContentConverter;
import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.api.StagingEmailHandler;

public class CreatePageEmailHandler
implements StagingEmailHandler<AbstractPage> {
    private final EmailStagingService emailStagingService;
    private final ConfirmationNotificationSender confirmationNotificationSender;
    private final EmailToContentConverter<AbstractPage> converter;

    public CreatePageEmailHandler(EmailStagingService emailStagingService, ConfirmationNotificationSender confirmationNotificationSender, EmailToContentConverter<AbstractPage> converter) {
        this.emailStagingService = emailStagingService;
        this.confirmationNotificationSender = confirmationNotificationSender;
        this.converter = converter;
    }

    public boolean handle(ReceivedEmail email) throws EmailHandlingException {
        try {
            this.emailStagingService.stageEmailThread(email, this.confirmationNotificationSender);
        }
        catch (EmailStagingException e) {
            throw new EmailHandlingException(e);
        }
        return true;
    }

    public ConfirmationNotificationSender getConfirmationNotificationSender() {
        return this.confirmationNotificationSender;
    }

    public EmailToContentConverter<AbstractPage> getConverter() {
        return this.converter;
    }
}

