/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.service;

import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.plugins.emailgateway.EmailBody;
import com.atlassian.confluence.plugins.emailgateway.api.AttachmentConverterService;
import com.atlassian.confluence.plugins.emailgateway.api.AttachmentFile;
import com.atlassian.confluence.plugins.emailgateway.api.EmailBodyType;
import com.atlassian.confluence.plugins.emailgateway.api.EmailHeaders;
import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.api.SerializableAttachment;
import com.atlassian.confluence.plugins.emailgateway.service.ReceivedEmailMimeConverter;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.mail.MailUtils;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.renderer.RenderContext;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReceivedEmailMimeConverter
implements ReceivedEmailMimeConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultReceivedEmailMimeConverter.class);
    private AttachmentConverterService attachmentConverterService;

    public DefaultReceivedEmailMimeConverter(AttachmentConverterService attachmentConverterService) {
        this.attachmentConverterService = attachmentConverterService;
    }

    @Override
    public ReceivedEmail convertMimeMessage(MimeMessage mimeMessage, InternetAddress recipient) throws MessagingException {
        EmailBody body = this.extractBody(mimeMessage);
        List<SerializableAttachment> attachments = this.extractAttachments(mimeMessage);
        InternetAddress sender = this.extractSender(mimeMessage);
        List<InternetAddress> participants = this.extractParticipants(recipient, mimeMessage);
        EmailHeaders headers = this.extractHeaders(mimeMessage.getAllHeaders());
        String subject = mimeMessage.getSubject();
        EmailBodyType bodyType = body.getType();
        String content = body.getContent();
        Map<String, ? extends Serializable> context = body.getContext();
        return new ReceivedEmail(sender, recipient, participants, headers, subject, bodyType, content, attachments, context);
    }

    private List<SerializableAttachment> extractAttachments(MimeMessage mimeMessage) throws MessagingException {
        ArrayList attachments = Lists.newArrayList();
        try {
            for (MailUtils.Attachment attachment : MailUtils.getAttachments((Message)mimeMessage)) {
                String contentType = this.stripContentTypeParameters(attachment.getContentType());
                attachments.add(new SerializableAttachment(attachment.getContents(), contentType, attachment.getFilename()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return attachments;
    }

    private String stripContentTypeParameters(String contentTypeStr) {
        return contentTypeStr.split(";")[0].trim();
    }

    private InternetAddress extractSender(MimeMessage mimeMessage) throws MessagingException {
        Address sender = mimeMessage.getSender();
        return sender != null ? (InternetAddress)sender : (InternetAddress)mimeMessage.getFrom()[0];
    }

    private Object getContent(final Part part) throws Exception {
        ClassLoader webappClassLoader = ConfluenceEvent.class.getClassLoader();
        return ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)webappClassLoader, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return part.getContent();
            }
        });
    }

    private EmailBody extractBody(MimeMessage mimeMessage) throws MessagingException {
        try {
            EmailBody emailBody;
            Object mimeMessageContent = this.getContent((Part)mimeMessage);
            if (mimeMessageContent instanceof Multipart) {
                emailBody = this.parseTopLevelMultipart((Multipart)mimeMessageContent);
            } else {
                String content = this.extractContent(mimeMessageContent);
                emailBody = new EmailBody(this.getEmailBodyType(mimeMessage), content);
            }
            return emailBody;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("Failed to extract email body content", e);
        }
    }

    private String extractContent(Object mimeMessageContent) throws Exception {
        if (mimeMessageContent instanceof String) {
            return (String)mimeMessageContent;
        }
        if (mimeMessageContent instanceof InputStream) {
            return IOUtils.toString((InputStream)((InputStream)mimeMessageContent), (Charset)Charset.defaultCharset());
        }
        if (mimeMessageContent instanceof Part) {
            return this.partToString((Part)mimeMessageContent);
        }
        throw new MessagingException("Don't know how to handle a received email with a content object of class " + mimeMessageContent.getClass().getName());
    }

    private EmailBody parseTopLevelMultipart(Multipart multipart) throws Exception {
        String contentType = this.stripContentTypeParameters(multipart.getContentType());
        if ("multipart/mixed".equals(contentType)) {
            return this.parseMultipartMixed(multipart);
        }
        if ("multipart/alternative".equals(contentType)) {
            return this.parseMultipartAlternative(multipart);
        }
        throw new MessagingException("Can't parse multipart email with content type: " + contentType);
    }

    private EmailBody parseMultipartMixed(Multipart multipart) throws Exception {
        ArrayList bodyParts = Lists.newArrayList();
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = this.stripContentTypeParameters(part.getContentType());
            if ("text/plain".equals(contentType)) {
                bodyParts.add(this.partToString((Part)part));
                continue;
            }
            if (!"inline".equals(part.getDisposition())) continue;
            String fileName = part.getFileName();
            String extension = StringUtils.substringAfterLast((String)fileName, (String)".").toLowerCase();
            AttachmentFile attachmentFile = new AttachmentFile(fileName, extension, contentType);
            String xmlStr = Streamables.writeToString((Streamable)this.attachmentConverterService.convert(attachmentFile));
            bodyParts.add(xmlStr);
        }
        String fullBody = StringUtils.join((Collection)bodyParts, (String)"\n");
        return new EmailBody(EmailBodyType.TEXT, fullBody);
    }

    private EmailBody parseMultipartAlternative(Multipart multipart) throws Exception {
        BodyPart textPart = null;
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = this.stripContentTypeParameters(part.getContentType());
            if ("multipart/related".equals(contentType)) {
                return this.parseMultipartRelated((Multipart)this.getContent((Part)part));
            }
            if ("text/html".equals(contentType)) {
                String htmlPartContent = this.partToString((Part)part);
                return new EmailBody(EmailBodyType.HTML, htmlPartContent);
            }
            if (!"text/plain".equals(contentType)) continue;
            textPart = part;
        }
        if (textPart != null) {
            String textPartContent = this.partToString((Part)textPart);
            return new EmailBody(EmailBodyType.TEXT, textPartContent);
        }
        throw new MessagingException("Couldn't find text, html, or multipart/related in message");
    }

    private EmailBody parseMultipartRelated(Multipart multipart) throws Exception {
        BodyPart htmlPart = null;
        HashMap attachmentCidToName = Maps.newHashMap();
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = this.stripContentTypeParameters(part.getContentType());
            if ("text/html".equals(contentType)) {
                htmlPart = part;
                continue;
            }
            if (!"inline".equals(part.getDisposition()) && !"attachment".equals(part.getDisposition())) continue;
            String fileName = part.getFileName();
            String cid = StringUtils.strip((String)part.getHeader("Content-ID")[0], (String)"<>");
            attachmentCidToName.put(cid, fileName);
        }
        if (htmlPart != null) {
            String htmlPartContent = this.partToString((Part)htmlPart);
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)new PageContext());
            conversionContext.setProperty("attachmentMap", (Object)attachmentCidToName);
            HashMap context = Maps.newHashMap();
            context.put("attachmentCidToName", attachmentCidToName);
            return new EmailBody(EmailBodyType.MULTIPART_RELATED, htmlPartContent, context);
        }
        throw new MessagingException("Couldn't find html part in multipart/related message");
    }

    private String partToString(Part mimeMessageContent) throws Exception {
        Object content = this.getContent(mimeMessageContent);
        if (content instanceof String) {
            return (String)content;
        }
        throw new MessagingException("Don't know how to handle a received part with a content object of class " + content.getClass().getName());
    }

    List<InternetAddress> extractParticipants(InternetAddress recipient, MimeMessage mimeMessage) throws MessagingException {
        ArrayList participants = Lists.newArrayList();
        this.addParticipants(participants, mimeMessage.getRecipients(Message.RecipientType.TO));
        this.addParticipants(participants, mimeMessage.getRecipients(Message.RecipientType.CC));
        participants.remove(recipient);
        return participants;
    }

    private void addParticipants(List<InternetAddress> participants, Address[] mimeMessageRecipients) {
        if (mimeMessageRecipients != null) {
            for (Address recipient : mimeMessageRecipients) {
                participants.add((InternetAddress)recipient);
            }
        }
    }

    private EmailBodyType getEmailBodyType(MimeMessage mimeMessage) throws MessagingException {
        if (mimeMessage.isMimeType("text/html")) {
            return EmailBodyType.HTML;
        }
        if (mimeMessage.isMimeType("text/plain")) {
            return EmailBodyType.TEXT;
        }
        throw new MessagingException("Unrecognised email content type: " + mimeMessage.getContentType());
    }

    private EmailHeaders extractHeaders(Enumeration mimeHeaderEnumeration) {
        LinkedHashMultimap headers = LinkedHashMultimap.create();
        while (mimeHeaderEnumeration.hasMoreElements()) {
            Header header = (Header)mimeHeaderEnumeration.nextElement();
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : headers.asMap().entrySet()) {
            String headerName = (String)entry.getKey();
            result.put(headerName, Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
        }
        return new EmailHeaders(result);
    }
}

