/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.emailgateway.api.ConfirmationNotificationSender;
import com.atlassian.confluence.plugins.emailgateway.api.EmailStagingException;
import com.atlassian.confluence.plugins.emailgateway.api.EmailStagingService;
import com.atlassian.confluence.plugins.emailgateway.api.EmailToContentConverter;
import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThread;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadAdminService;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThreadKey;
import com.atlassian.confluence.plugins.emailgateway.api.UsersByEmailService;
import com.atlassian.confluence.plugins.emailgateway.blacklist.Blacklist;
import com.atlassian.confluence.plugins.emailgateway.service.EmailThreadConversionStartedEvent;
import com.atlassian.confluence.plugins.emailgateway.service.EmailThreadConvertedEvent;
import com.atlassian.confluence.plugins.emailgateway.service.EmailThreadStagedEvent;
import com.atlassian.confluence.plugins.emailgateway.service.StagedEmailThreadManager;
import com.atlassian.confluence.plugins.emailgateway.service.UserBlacklistedException;
import com.atlassian.confluence.validation.MessageHolder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DefaultEmailThreadConverterService
implements StagedEmailThreadAdminService,
EmailStagingService {
    private final StagedEmailThreadManager stagedEmailThreadManager;
    private final UsersByEmailService usersByEmailService;
    private final SecureTokenGenerator secureTokenGenerator;
    private final EventPublisher eventPublisher;
    private final Blacklist<User> blacklist;

    public DefaultEmailThreadConverterService(StagedEmailThreadManager stagedEmailThreadManager, UsersByEmailService usersByEmailService, SecureTokenGenerator secureTokenGenerator, EventPublisher eventPublisher, Blacklist<User> blacklist) {
        this.stagedEmailThreadManager = stagedEmailThreadManager;
        this.usersByEmailService = usersByEmailService;
        this.secureTokenGenerator = secureTokenGenerator;
        this.eventPublisher = eventPublisher;
        this.blacklist = blacklist;
    }

    @Override
    public StagedEmailThreadKey stageEmailThread(ReceivedEmail receivedEmail, ConfirmationNotificationSender confirmationNotificationSender) throws EmailStagingException {
        return this.doStageEmailThread(receivedEmail, confirmationNotificationSender).getKey();
    }

    StagedEmailThread doStageEmailThread(ReceivedEmail receivedEmail, ConfirmationNotificationSender confirmationNotificationSender) throws EmailStagingException {
        User user;
        StagedEmailThreadKey stagedEmailThreadKey = new StagedEmailThreadKey(this.secureTokenGenerator.generateToken());
        String userAddress = receivedEmail.getSender().getAddress();
        try {
            user = this.usersByEmailService.getUniqueUserByEmail(userAddress);
        }
        catch (EntityException e) {
            throw new EmailStagingException(e.getMessage(), e);
        }
        if (user == null) {
            throw new EmailStagingException("No user with email address: " + userAddress);
        }
        if (this.blacklist.incrementAndCheckBlacklist(user)) {
            throw new UserBlacklistedException(user);
        }
        StagedEmailThread stagedEmailThread = new StagedEmailThread(stagedEmailThreadKey, DefaultEmailThreadConverterService.getSpaceKeyForUser(user), receivedEmail);
        this.stagedEmailThreadManager.storeStagedEmailThread(stagedEmailThread);
        confirmationNotificationSender.sendConfirmationEmail(user, stagedEmailThread);
        this.eventPublisher.publish((Object)new EmailThreadStagedEvent(stagedEmailThread));
        return stagedEmailThread;
    }

    @Override
    public int clearExpiredEmailThreads(DateTime expiry) {
        int count = 0;
        for (StagedEmailThread thread : this.stagedEmailThreadManager) {
            if (!expiry.isAfter((ReadableInstant)thread.getStagingDate())) continue;
            this.stagedEmailThreadManager.deleteStagedEmailThread(thread.getKey());
            ++count;
        }
        return count;
    }

    private static String getSpaceKeyForUser(User user) {
        return "~" + user.getName();
    }

    @Override
    public <C extends ContentEntityObject> C convertAndPublishStagedEmailThread(StagedEmailThreadKey key, MessageHolder messageHolder, EmailToContentConverter<C> emailToContentConverter) {
        this.eventPublisher.publish((Object)new EmailThreadConversionStartedEvent(key));
        StagedEmailThread thread = this.stagedEmailThreadManager.findStagedEmailThread(key);
        if (thread == null) {
            throw new IllegalArgumentException("Could not locate a staged email thread using key " + key);
        }
        C content = emailToContentConverter.publish(thread, messageHolder);
        this.eventPublisher.publish((Object)new EmailThreadConvertedEvent(thread, (ContentEntityObject)content));
        this.stagedEmailThreadManager.deleteStagedEmailThread(key);
        return content;
    }

    @Override
    public void deleteStagedEmailThread(StagedEmailThreadKey key) {
        this.stagedEmailThreadManager.deleteStagedEmailThread(key);
    }
}

