/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emfplus;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emfplus.HemfPlusDraw;
import org.apache.poi.hemf.record.emfplus.HemfPlusHeader;
import org.apache.poi.hemf.record.emfplus.HemfPlusObject;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.hwmf.usermodel.HwmfPicture;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordJsonWriter;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.Units;

public class HemfPlusImage {
    private static final int MAX_IMAGE_SIZE = 1500;

    public static class EmfPlusImageAttributes
    implements HemfPlusObject.EmfPlusObjectData {
        private final HemfPlusHeader.EmfPlusGraphicsVersion graphicsVersion = new HemfPlusHeader.EmfPlusGraphicsVersion();
        private EmfPlusWrapMode wrapMode;
        private Color clampColor;
        private EmfPlusObjectClamp objectClamp;

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, HemfPlusObject.EmfPlusObjectType objectType, int flags) throws IOException {
            long size = this.graphicsVersion.init(leis);
            leis.skipFully(4);
            this.wrapMode = EmfPlusWrapMode.valueOf(leis.readInt());
            this.clampColor = HemfPlusDraw.readARGB(leis.readInt());
            this.objectClamp = EmfPlusObjectClamp.valueOf(leis.readInt());
            leis.skipFully(4);
            return size + 20L;
        }

        @Override
        public HemfPlusHeader.EmfPlusGraphicsVersion getGraphicsVersion() {
            return this.graphicsVersion;
        }

        public EmfPlusWrapMode getWrapMode() {
            return this.wrapMode;
        }

        public Color getClampColor() {
            return this.clampColor;
        }

        public EmfPlusObjectClamp getObjectClamp() {
            return this.objectClamp;
        }

        @Override
        public void applyObject(HemfGraphics ctx, List<? extends HemfPlusObject.EmfPlusObjectData> continuedObjectData) {
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal(this);
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("graphicsVersion", this::getGraphicsVersion, "wrapMode", this::getWrapMode, "clampColor", this::getClampColor, "objectClamp", this::getObjectClamp);
        }

        @Override
        public HemfPlusObject.EmfPlusObjectType getGenericRecordType() {
            return HemfPlusObject.EmfPlusObjectType.IMAGE_ATTRIBUTES;
        }
    }

    public static class EmfPlusImage
    implements HemfPlusObject.EmfPlusObjectData {
        private static final int MAX_OBJECT_SIZE = 50000000;
        private final HemfPlusHeader.EmfPlusGraphicsVersion graphicsVersion = new HemfPlusHeader.EmfPlusGraphicsVersion();
        private EmfPlusImageDataType imageDataType;
        private int bitmapWidth;
        private int bitmapHeight;
        private int bitmapStride;
        private EmfPlusPixelFormat pixelFormat;
        private EmfPlusBitmapDataType bitmapType;
        private byte[] imageData;
        private EmfPlusMetafileDataType metafileType;
        private int metafileDataSize;

        public EmfPlusImageDataType getImageDataType() {
            return this.imageDataType;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public EmfPlusPixelFormat getPixelFormat() {
            return this.pixelFormat;
        }

        public EmfPlusBitmapDataType getBitmapType() {
            return this.bitmapType;
        }

        public int getBitmapWidth() {
            return this.bitmapWidth;
        }

        public int getBitmapHeight() {
            return this.bitmapHeight;
        }

        public int getBitmapStride() {
            return this.bitmapStride;
        }

        public EmfPlusMetafileDataType getMetafileType() {
            return this.metafileType;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize, HemfPlusObject.EmfPlusObjectType objectType, int flags) throws IOException {
            int fileSize;
            leis.mark(4);
            long size = this.graphicsVersion.init(leis);
            if (this.isContinuedRecord()) {
                this.imageDataType = EmfPlusImageDataType.CONTINUED;
                leis.reset();
                size = 0L;
            } else {
                this.imageDataType = EmfPlusImageDataType.valueOf(leis.readInt());
                size += 4L;
            }
            if (this.imageDataType == null) {
                this.imageDataType = EmfPlusImageDataType.UNKNOWN;
            }
            switch (this.imageDataType) {
                default: {
                    this.bitmapWidth = -1;
                    this.bitmapHeight = -1;
                    this.bitmapStride = -1;
                    this.bitmapType = null;
                    this.pixelFormat = null;
                    fileSize = (int)dataSize;
                    break;
                }
                case BITMAP: {
                    this.bitmapWidth = leis.readInt();
                    this.bitmapHeight = leis.readInt();
                    this.bitmapStride = leis.readInt();
                    int pixelFormatInt = leis.readInt();
                    this.bitmapType = EmfPlusBitmapDataType.valueOf(leis.readInt());
                    size += 20L;
                    EmfPlusPixelFormat emfPlusPixelFormat = this.pixelFormat = this.bitmapType == EmfPlusBitmapDataType.PIXEL ? EmfPlusPixelFormat.valueOf(pixelFormatInt) : EmfPlusPixelFormat.UNDEFINED;
                    assert (this.pixelFormat != null);
                    fileSize = (int)(dataSize - size);
                    break;
                }
                case METAFILE: {
                    this.metafileType = EmfPlusMetafileDataType.valueOf(leis.readInt());
                    this.metafileDataSize = leis.readInt();
                    fileSize = (int)(dataSize - (size += 8L));
                }
            }
            assert ((long)fileSize <= dataSize - size);
            this.imageData = IOUtils.toByteArray(leis, fileSize, 50000000);
            return size + (long)fileSize;
        }

        @Override
        public HemfPlusHeader.EmfPlusGraphicsVersion getGraphicsVersion() {
            return this.graphicsVersion;
        }

        public Rectangle2D getBounds(List<? extends HemfPlusObject.EmfPlusObjectData> continuedObjectData) {
            try {
                switch (this.getImageDataType()) {
                    case BITMAP: {
                        if (this.getBitmapType() == EmfPlusBitmapDataType.PIXEL) {
                            return new Rectangle2D.Double(0.0, 0.0, this.bitmapWidth, this.bitmapHeight);
                        }
                        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.getRawData(continuedObjectData)));
                        return new Rectangle2D.Double(bi.getMinX(), bi.getMinY(), bi.getWidth(), bi.getHeight());
                    }
                    case METAFILE: {
                        ByteArrayInputStream bis = new ByteArrayInputStream(this.getRawData(continuedObjectData));
                        switch (this.getMetafileType()) {
                            case Wmf: 
                            case WmfPlaceable: {
                                HwmfPicture wmf = new HwmfPicture(bis);
                                return wmf.getBounds();
                            }
                            case Emf: 
                            case EmfPlusDual: 
                            case EmfPlusOnly: {
                                HemfPicture emf = new HemfPicture(bis);
                                return emf.getBounds();
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
        }

        public byte[] getRawData(List<? extends HemfPlusObject.EmfPlusObjectData> continuedObjectData) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                bos.write(this.getImageData());
                if (continuedObjectData != null) {
                    for (HemfPlusObject.EmfPlusObjectData emfPlusObjectData : continuedObjectData) {
                        bos.write(((EmfPlusImage)emfPlusObjectData).getImageData());
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }

        @Override
        public void applyObject(HemfGraphics ctx, List<? extends HemfPlusObject.EmfPlusObjectData> continuedObjectData) {
            HemfDrawProperties prop = ctx.getProperties();
            BufferedImage bi = this.readImage(this.getRawData(continuedObjectData));
            prop.setEmfPlusImage(bi);
        }

        public BufferedImage readGDIImage(byte[] data) {
            int[] bOffs;
            int[] nBits;
            if (this.getImageDataType() != EmfPlusImageDataType.BITMAP || this.getBitmapType() != EmfPlusBitmapDataType.PIXEL) {
                throw new RuntimeException("image data is not a GDI image");
            }
            int width = this.getBitmapWidth();
            int height = this.getBitmapHeight();
            int stride = this.getBitmapStride();
            EmfPlusPixelFormat pf = this.getPixelFormat();
            switch (pf) {
                case ARGB_32BPP: {
                    nBits = new int[]{8, 8, 8, 8};
                    bOffs = new int[]{2, 1, 0, 3};
                    break;
                }
                case RGB_24BPP: {
                    nBits = new int[]{8, 8, 8};
                    bOffs = new int[]{2, 1, 0};
                    break;
                }
                default: {
                    throw new RuntimeException("not yet implemented");
                }
            }
            ColorSpace cs = ColorSpace.getInstance(1000);
            ComponentColorModel cm = new ComponentColorModel(cs, nBits, pf.isAlpha(), pf.isPreMultiplied(), 3, 0);
            PixelInterleavedSampleModel csm = new PixelInterleavedSampleModel(cm.getTransferType(), width, height, cm.getNumComponents(), stride, bOffs);
            DataBufferByte dbb = new DataBufferByte(data, data.length);
            WritableRaster raster = (WritableRaster)Raster.createRaster(csm, dbb, null);
            return new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        }

        private BufferedImage readImage(byte[] data) {
            try {
                switch (this.getImageDataType()) {
                    case BITMAP: {
                        BufferedImage bi = this.getBitmapType() == EmfPlusBitmapDataType.PIXEL ? this.readGDIImage(data) : ImageIO.read(new ByteArrayInputStream(data));
                        return bi;
                    }
                    case METAFILE: {
                        assert (this.getMetafileType() != null);
                        switch (this.getMetafileType()) {
                            case Wmf: 
                            case WmfPlaceable: {
                                HwmfPicture wmf = new HwmfPicture(new ByteArrayInputStream(data));
                                return this.readImage(wmf.getSize(), wmf::draw);
                            }
                            case Emf: 
                            case EmfPlusDual: 
                            case EmfPlusOnly: {
                                HemfPicture emf = new HemfPicture(new ByteArrayInputStream(data));
                                return this.readImage(emf.getSize(), emf::draw);
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new BufferedImage(1, 1, 2);
        }

        private BufferedImage readImage(Dimension2D dim, BiConsumer<Graphics2D, Rectangle2D> draw) {
            int height;
            int width = Units.pointsToPixel(dim.getWidth());
            double longSide = Math.max(width, height = Units.pointsToPixel(dim.getHeight()));
            if (longSide > 1500.0) {
                double scale = 1500.0 / longSide;
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            }
            BufferedImage bufImg = new BufferedImage(width, height, 2);
            Graphics2D g = bufImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            draw.accept(g, new Rectangle2D.Double(0.0, 0.0, width, height));
            g.dispose();
            return bufImg;
        }

        public String toString() {
            return GenericRecordJsonWriter.marshal(this);
        }

        @Override
        public HemfPlusObject.EmfPlusObjectType getGenericRecordType() {
            return HemfPlusObject.EmfPlusObjectType.IMAGE;
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            LinkedHashMap<String, Supplier<Object>> m = new LinkedHashMap<String, Supplier<Object>>();
            m.put("graphicsVersion", this::getGraphicsVersion);
            m.put("imageDataType", this::getImageDataType);
            m.put("bitmapWidth", this::getBitmapWidth);
            m.put("bitmapHeight", this::getBitmapHeight);
            m.put("bitmapStride", this::getBitmapStride);
            m.put("pixelFormat", this::getPixelFormat);
            m.put("bitmapType", this::getBitmapType);
            m.put("imageData", this::getImageData);
            m.put("metafileType", this::getMetafileType);
            m.put("metafileDataSize", () -> this.metafileDataSize);
            return Collections.unmodifiableMap(m);
        }
    }

    public static enum EmfPlusObjectClamp {
        RectClamp(0),
        BitmapClamp(1);

        public final int id;

        private EmfPlusObjectClamp(int id) {
            this.id = id;
        }

        public static EmfPlusObjectClamp valueOf(int id) {
            for (EmfPlusObjectClamp wrt : EmfPlusObjectClamp.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }

    public static enum EmfPlusWrapMode {
        WRAP_MODE_TILE(0),
        WRAP_MODE_TILE_FLIP_X(1),
        WRAP_MODE_TILE_FLIP_Y(2),
        WRAP_MODE_TILE_FLIP_XY(3),
        WRAP_MODE_CLAMP(4);

        public final int id;

        private EmfPlusWrapMode(int id) {
            this.id = id;
        }

        public static EmfPlusWrapMode valueOf(int id) {
            for (EmfPlusWrapMode wrt : EmfPlusWrapMode.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }

    public static enum EmfPlusMetafileDataType {
        Wmf(1),
        WmfPlaceable(2),
        Emf(3),
        EmfPlusOnly(4),
        EmfPlusDual(5);

        public final int id;

        private EmfPlusMetafileDataType(int id) {
            this.id = id;
        }

        public static EmfPlusMetafileDataType valueOf(int id) {
            for (EmfPlusMetafileDataType wrt : EmfPlusMetafileDataType.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }

    public static enum EmfPlusBitmapDataType {
        PIXEL(0),
        COMPRESSED(1);

        public final int id;

        private EmfPlusBitmapDataType(int id) {
            this.id = id;
        }

        public static EmfPlusBitmapDataType valueOf(int id) {
            for (EmfPlusBitmapDataType wrt : EmfPlusBitmapDataType.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }

    public static enum EmfPlusPixelFormat {
        UNDEFINED(0),
        INDEXED_1BPP(196865),
        INDEXED_4BPP(197634),
        INDEXED_8BPP(198659),
        GRAYSCALE_16BPP(0x101004),
        RGB555_16BPP(135173),
        RGB565_16BPP(135174),
        ARGB1555_16BPP(397319),
        RGB_24BPP(137224),
        RGB_32BPP(139273),
        ARGB_32BPP(2498570),
        PARGB_32BPP(925707),
        RGB_48BPP(1060876),
        ARGB_64BPP(3424269),
        PARGB_64BPP(1720334);

        private static final BitField CANONICAL;
        private static final BitField EXTCOLORS;
        private static final BitField PREMULTI;
        private static final BitField ALPHA;
        private static final BitField GDI;
        private static final BitField PALETTE;
        private static final BitField BPP;
        private static final BitField INDEX;
        public final int id;

        private EmfPlusPixelFormat(int id) {
            this.id = id;
        }

        public static EmfPlusPixelFormat valueOf(int id) {
            for (EmfPlusPixelFormat wrt : EmfPlusPixelFormat.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }

        public int getGDIEnumIndex() {
            return this.id == -1 ? -1 : INDEX.getValue(this.id);
        }

        public int getBitsPerPixel() {
            return this.id == -1 ? -1 : BPP.getValue(this.id);
        }

        public boolean isPaletteIndexed() {
            return this.id != -1 && PALETTE.isSet(this.id);
        }

        public boolean isGDISupported() {
            return this.id != -1 && GDI.isSet(this.id);
        }

        public boolean isAlpha() {
            return this.id != -1 && ALPHA.isSet(this.id);
        }

        public boolean isPreMultiplied() {
            return this.id != -1 && PREMULTI.isSet(this.id);
        }

        public boolean isExtendedColors() {
            return this.id != -1 && EXTCOLORS.isSet(this.id);
        }

        public boolean isCanonical() {
            return this.id != -1 && CANONICAL.isSet(this.id);
        }

        static {
            CANONICAL = BitFieldFactory.getInstance(0x200000);
            EXTCOLORS = BitFieldFactory.getInstance(0x100000);
            PREMULTI = BitFieldFactory.getInstance(524288);
            ALPHA = BitFieldFactory.getInstance(262144);
            GDI = BitFieldFactory.getInstance(131072);
            PALETTE = BitFieldFactory.getInstance(65536);
            BPP = BitFieldFactory.getInstance(65280);
            INDEX = BitFieldFactory.getInstance(255);
        }
    }

    public static enum EmfPlusImageDataType {
        UNKNOWN(0),
        BITMAP(1),
        METAFILE(2),
        CONTINUED(-1);

        public final int id;

        private EmfPlusImageDataType(int id) {
            this.id = id;
        }

        public static EmfPlusImageDataType valueOf(int id) {
            for (EmfPlusImageDataType wrt : EmfPlusImageDataType.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }
}

