/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.usermodel;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfHeader;
import org.apache.poi.hwmf.record.HwmfPlaceableHeader;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfWindowing;
import org.apache.poi.hwmf.usermodel.HwmfEmbedded;
import org.apache.poi.hwmf.usermodel.HwmfEmbeddedIterator;
import org.apache.poi.util.Dimension2DDouble;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.util.Units;

public class HwmfPicture
implements Iterable<HwmfRecord>,
GenericRecord {
    public static final int MAX_RECORD_LENGTH = 50000000;
    private static final POILogger logger = POILogFactory.getLogger(HwmfPicture.class);
    final List<HwmfRecord> records;
    final HwmfPlaceableHeader placeableHeader;
    final HwmfHeader header;

    public HwmfPicture(InputStream inputStream) throws IOException {
        block20: {
            this.records = new ArrayList<HwmfRecord>();
            try (LittleEndianInputStream leis = new LittleEndianInputStream(inputStream);){
                long skipped;
                int remainingSize;
                this.placeableHeader = HwmfPlaceableHeader.readHeader(leis);
                this.header = new HwmfHeader(leis);
                do {
                    short recordFunction;
                    long recordSize;
                    try {
                        long recordSizeLong = leis.readUInt() * 2L;
                        if (recordSizeLong > Integer.MAX_VALUE) {
                            throw new RecordFormatException("record size can't be > 2147483647");
                        }
                        if (recordSizeLong < 0L) {
                            throw new RecordFormatException("record size can't be < 0");
                        }
                        recordSize = (int)recordSizeLong;
                        recordFunction = leis.readShort();
                    }
                    catch (Exception e) {
                        logger.log(7, "unexpected eof - wmf file was truncated");
                        break block20;
                    }
                    int consumedSize = 6;
                    HwmfRecordType wrt = HwmfRecordType.getById(recordFunction);
                    if (wrt == null) {
                        throw new IOException("unexpected record type: " + recordFunction);
                    }
                    if (wrt == HwmfRecordType.eof) {
                        break block20;
                    }
                    if (wrt.constructor == null) {
                        throw new IOException("unsupported record type: " + recordFunction);
                    }
                    HwmfRecord wr = wrt.constructor.get();
                    this.records.add(wr);
                    remainingSize = (int)(recordSize - (long)(consumedSize += wr.init(leis, recordSize, recordFunction)));
                    if (remainingSize >= 0) continue;
                    throw new RecordFormatException("read too many bytes. record size: " + recordSize + "; comsumed size: " + consumedSize);
                } while (remainingSize <= 0 || (skipped = IOUtils.skipFully(leis, remainingSize)) == (long)remainingSize);
                throw new RecordFormatException("Tried to skip " + remainingSize + " but skipped: " + skipped);
            }
        }
    }

    public List<HwmfRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public void draw(Graphics2D ctx) {
        Dimension2D dim = this.getSize();
        int width = Units.pointsToPixel(dim.getWidth());
        int height = Units.pointsToPixel(dim.getHeight());
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.draw(ctx, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
        Shape clip = ctx.getClip();
        AffineTransform at = ctx.getTransform();
        try {
            Rectangle2D wmfBounds = this.getBounds();
            Rectangle2D innerBounds = this.getInnnerBounds();
            if (innerBounds == null) {
                innerBounds = wmfBounds;
            }
            ctx.translate(graphicsBounds.getX(), graphicsBounds.getY());
            ctx.scale(graphicsBounds.getWidth() / wmfBounds.getWidth(), graphicsBounds.getHeight() / wmfBounds.getHeight());
            ctx.translate(-wmfBounds.getX(), -wmfBounds.getY());
            ctx.translate(innerBounds.getCenterX(), innerBounds.getCenterY());
            ctx.scale(wmfBounds.getWidth() / innerBounds.getWidth(), wmfBounds.getHeight() / innerBounds.getHeight());
            ctx.translate(-wmfBounds.getCenterX(), -wmfBounds.getCenterY());
            HwmfGraphics g = new HwmfGraphics(ctx, innerBounds);
            HwmfDrawProperties prop = g.getProperties();
            prop.setViewportOrg(innerBounds.getX(), innerBounds.getY());
            prop.setViewportExt(innerBounds.getWidth(), innerBounds.getHeight());
            int idx = 0;
            for (HwmfRecord r : this.records) {
                Shape ctxClip;
                prop = g.getProperties();
                Shape propClip = prop.getClip();
                if (!Objects.equals(propClip, ctxClip = ctx.getClip())) {
                    int n = 5;
                }
                r.draw(g);
                ++idx;
            }
        }
        finally {
            ctx.setTransform(at);
            ctx.setClip(clip);
        }
    }

    public Rectangle2D getBounds() {
        if (this.placeableHeader != null) {
            return this.placeableHeader.getBounds();
        }
        Rectangle2D inner = this.getInnnerBounds();
        if (inner != null) {
            return inner;
        }
        throw new RuntimeException("invalid wmf file - window records are incomplete.");
    }

    public Rectangle2D getInnnerBounds() {
        HwmfWindowing.WmfSetWindowOrg wOrg = null;
        HwmfWindowing.WmfSetWindowExt wExt = null;
        for (HwmfRecord r : this.getRecords()) {
            if (r instanceof HwmfWindowing.WmfSetWindowOrg) {
                wOrg = (HwmfWindowing.WmfSetWindowOrg)r;
            } else if (r instanceof HwmfWindowing.WmfSetWindowExt) {
                wExt = (HwmfWindowing.WmfSetWindowExt)r;
            }
            if (wOrg == null || wExt == null) continue;
            return new Rectangle2D.Double(wOrg.getX(), wOrg.getY(), wExt.getSize().getWidth(), wExt.getSize().getHeight());
        }
        return null;
    }

    public HwmfPlaceableHeader getPlaceableHeader() {
        return this.placeableHeader;
    }

    public HwmfHeader getHeader() {
        return this.header;
    }

    public Dimension2D getSize() {
        double inch = this.placeableHeader == null ? 1440.0 : (double)this.placeableHeader.getUnitsPerInch();
        Rectangle2D bounds = this.getBounds();
        double coeff = 72.0 / inch;
        return new Dimension2DDouble(bounds.getWidth() * coeff, bounds.getHeight() * coeff);
    }

    public Iterable<HwmfEmbedded> getEmbeddings() {
        return () -> new HwmfEmbeddedIterator(this);
    }

    @Override
    public Iterator<HwmfRecord> iterator() {
        return this.getRecords().iterator();
    }

    @Override
    public Spliterator<HwmfRecord> spliterator() {
        return this.getRecords().spliterator();
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return null;
    }

    @Override
    public List<? extends GenericRecord> getGenericChildren() {
        return this.getRecords();
    }
}

