/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl.runnable.cloud;

import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.CloudRequest;
import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.HttpMethod;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;

public class CloudRequestBuilder<T> {
    private final HttpMethod httpMethod;
    private final String url;
    private String authorisationToken = null;
    private ResponseHandler<T> responseHandler = null;
    private String requestName = null;
    private CloseableHttpClient client;
    private ImmutableList.Builder<Header> headers = ImmutableList.builder();
    private HttpEntity entity;

    public static <T> CloudRequestBuilder<T> get(String url, Class<T> clazz) {
        return new CloudRequestBuilder<T>(HttpMethod.GET, url);
    }

    public static <T> CloudRequestBuilder<T> head(String url, Class<T> clazz) {
        return new CloudRequestBuilder<T>(HttpMethod.HEAD, url);
    }

    public static <T> CloudRequestBuilder<T> post(String url, Class<T> clazz) {
        return new CloudRequestBuilder<T>(HttpMethod.POST, url);
    }

    public static <T> CloudRequestBuilder<T> put(String url, Class<T> clazz) {
        return new CloudRequestBuilder<T>(HttpMethod.PUT, url);
    }

    public static <T> CloudRequestBuilder<T> delete(String url, Class<T> clazz) {
        return new CloudRequestBuilder<T>(HttpMethod.DELETE, url);
    }

    public static CloudRequestBuilder<Void> get(String url) {
        return new CloudRequestBuilder<Void>(HttpMethod.GET, url);
    }

    public static CloudRequestBuilder<Void> head(String url) {
        return new CloudRequestBuilder<Void>(HttpMethod.HEAD, url);
    }

    public static CloudRequestBuilder<Void> post(String url) {
        return new CloudRequestBuilder<Void>(HttpMethod.POST, url);
    }

    public static CloudRequestBuilder<Void> put(String url) {
        return new CloudRequestBuilder<Void>(HttpMethod.PUT, url);
    }

    public static CloudRequestBuilder<Void> delete(String url) {
        return new CloudRequestBuilder<Void>(HttpMethod.DELETE, url);
    }

    private CloudRequestBuilder(HttpMethod method, String url) {
        Preconditions.checkNotNull((Object)((Object)method));
        Preconditions.checkNotNull((Object)url);
        this.httpMethod = method;
        this.url = url;
    }

    public CloudRequestBuilder<T> client(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    public CloudRequestBuilder<T> authorisationToken(String authorisationToken) {
        this.authorisationToken = authorisationToken;
        return this;
    }

    public CloudRequestBuilder<T> responseHandler(ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public CloudRequestBuilder<T> requestName(String requestName) {
        this.requestName = requestName;
        return this;
    }

    public CloudRequestBuilder<T> header(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.headers.add((Object)new BasicHeader(name, value));
        return this;
    }

    public CloudRequestBuilder<T> contentType(String contentType) {
        return this.header("Content-Type", contentType);
    }

    public CloudRequestBuilder<T> entity(HttpEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
        return this;
    }

    public CloudRequest<T> build() {
        Preconditions.checkNotNull((Object)this.requestName, (Object)"A request name must be specified");
        Preconditions.checkNotNull((Object)this.client, (Object)"An HTTP client must be provided");
        return new CloudRequest<T>(this.client, this.httpMethod, this.url, this.authorisationToken, this.responseHandler, this.requestName, (List<Header>)this.headers.build(), this.entity);
    }
}

