/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlException;

public class XSSFExcelExtractor
extends POIXMLTextExtractor
implements ExcelExtractor {
    private XSSFWorkbook workbook;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeCellComments = false;
    private boolean includeHeadersFooters = true;

    public XSSFExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(path));
    }

    public XSSFExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(container));
    }

    public XSSFExcelExtractor(XSSFWorkbook workbook) {
        super(workbook);
        this.workbook = workbook;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HXFExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFExcelExtractor extractor = new XSSFExcelExtractor(args[0]);
        System.out.println(((POITextExtractor)extractor).getText());
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public void setIncludeCellComments(boolean includeCellComments) {
        this.includeCellComments = includeCellComments;
    }

    public void setIncludeHeadersFooters(boolean includeHeadersFooters) {
        this.includeHeadersFooters = includeHeadersFooters;
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            XSSFSheet sheet = this.workbook.getSheetAt(i);
            if (this.includeSheetNames) {
                text.append(this.workbook.getSheetName(i)).append("\n");
            }
            if (this.includeHeadersFooters) {
                text.append(this.extractHeaderFooter(sheet.getFirstHeader()));
                text.append(this.extractHeaderFooter(sheet.getOddHeader()));
                text.append(this.extractHeaderFooter(sheet.getEvenHeader()));
            }
            Iterator<Row> i$ = sheet.iterator();
            while (i$.hasNext()) {
                Row rawR;
                Row row = rawR = i$.next();
                Iterator<Cell> ri = row.cellIterator();
                while (ri.hasNext()) {
                    Cell cell = ri.next();
                    if (cell.getCellType() == 2 && this.formulasNotResults) {
                        text.append(cell.getCellFormula());
                    } else if (cell.getCellType() == 1) {
                        text.append(cell.getRichStringCellValue().getString());
                    } else {
                        XSSFCell xc = (XSSFCell)cell;
                        text.append(xc.getRawValue());
                    }
                    Comment comment = cell.getCellComment();
                    if (this.includeCellComments && comment != null) {
                        String commentText = comment.getString().getString().replace('\n', ' ');
                        text.append(" Comment by ").append(comment.getAuthor()).append(": ").append(commentText);
                    }
                    if (!ri.hasNext()) continue;
                    text.append("\t");
                }
                text.append("\n");
            }
            if (!this.includeHeadersFooters) continue;
            text.append(this.extractHeaderFooter(sheet.getFirstFooter()));
            text.append(this.extractHeaderFooter(sheet.getOddFooter()));
            text.append(this.extractHeaderFooter(sheet.getEvenFooter()));
        }
        return text.toString();
    }

    private String extractHeaderFooter(HeaderFooter hf) {
        return org.apache.poi.hssf.extractor.ExcelExtractor._extractHeaderFooter(hf);
    }
}

