/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.extract.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlbeans.XmlOptions;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SecureXmlUtils {
    public static EntityResolver emptyEntityResolver = new EmptyEntityResolver();

    public static XmlOptions createSecureXmlOptions(SAXParserFactory spf) throws SAXException, ParserConfigurationException {
        XmlOptions opts = new XmlOptions();
        opts.setLoadUseXMLReader(SecureXmlUtils.createSecureXMLReader(spf));
        return opts;
    }

    public static SAXParserFactory createSecureSAXParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return spf;
    }

    public static XMLReader createSecureXMLReader(SAXParserFactory spf) throws SAXException, ParserConfigurationException {
        XMLReader xr = spf.newSAXParser().getXMLReader();
        xr.setEntityResolver(emptyEntityResolver);
        return xr;
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        private static InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        private EmptyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

