/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dashboard;

import com.atlassian.core.filters.AbstractHttpFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgContentTypeFilter
extends AbstractHttpFilter {
    private static final Logger log = LoggerFactory.getLogger(SvgContentTypeFilter.class);

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            URI requestURI = new URI(request.getRequestURI());
            if (!requestURI.getPath().endsWith(".svg")) {
                return;
            }
            log.debug("Overriding Content-Type header for SVG file");
            response.setContentType("image/svg+xml");
            response = new HttpServletResponseWrapper((HttpServletResponse)response){

                public void setContentType(String newContentType) {
                    log.debug("Ignoring attempt to set the content type header to: " + newContentType);
                }

                public void setHeader(String name, String value) {
                    if ("Content-Type".equals(name)) {
                        this.setContentType(value);
                        return;
                    }
                    super.setHeader(name, value);
                }
            };
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse URI " + request.getRequestURI(), e);
        }
        finally {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

