/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.scheduling;

import com.atlassian.confluence.plugins.dailysummary.components.SummaryEmailService;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryEmailJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(SummaryEmailJob.class);
    private AtomicBoolean lock = new AtomicBoolean(false);
    private SummaryEmailService summaryEmailService;

    public SummaryEmailJob(SummaryEmailService summaryEmailService) {
        this.summaryEmailService = summaryEmailService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("Executing scheduled Summary Email Job");
        if (!this.lock.compareAndSet(false, true)) {
            log.warn("MisFired for the Scheduled Summary Email Job");
            return;
        }
        try {
            Date fireTime = context.getScheduledFireTime();
            int numSent = this.summaryEmailService.sendEmailForDate(fireTime);
            log.info("Completed scheduled Summary email job, {} emails added to notification queue", (Object)numSent);
        }
        finally {
            this.lock.set(false);
        }
    }
}

