/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentTemplateRefAo;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/templatesRefs")
public class ContentTemplateRefResource
extends AbstractRestResource {
    public static final String PARAM_ID = "id";
    private final ContentTemplateRefManager contentTemplateRefManager;
    private final ActiveObjects activeObjects;

    public ContentTemplateRefResource(PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, ContentTemplateRefManager contentTemplateRefManager, ActiveObjects activeObjects) {
        super(permissionManager, spaceManager, spacePermissionManager);
        this.contentTemplateRefManager = contentTemplateRefManager;
        this.activeObjects = activeObjects;
    }

    @DELETE
    @Path(value="deleteAll")
    public Integer deleteAll() {
        this.checkAdminPermission();
        return this.contentTemplateRefManager.deleteAll();
    }

    @GET
    @Path(value="{id}")
    public ContentTemplateRef get(@PathParam(value="id") UUID uuid) {
        this.checkNullParameter(uuid, PARAM_ID);
        return (ContentTemplateRef)this.contentTemplateRefManager.getById(uuid);
    }

    @DELETE
    @Path(value="{id}")
    public boolean delete(@PathParam(value="id") UUID uuid) {
        this.checkNullParameter(uuid, PARAM_ID);
        return this.contentTemplateRefManager.delete(uuid);
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public UUID create(final ContentTemplateRef contentTemplateRef) {
        this.checkNullEntity(contentTemplateRef);
        ContentTemplateRefAo ao = (ContentTemplateRefAo)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<ContentTemplateRefAo>(){

            public ContentTemplateRefAo doInTransaction() {
                return ContentTemplateRefResource.this.saveContentTemplateRef(contentTemplateRef);
            }
        });
        if (ao != null) {
            return UUID.fromString(ao.getUuid());
        }
        return null;
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    public void update(ContentTemplateRef contentTemplateRef) {
        this.contentTemplateRefManager.update(contentTemplateRef);
        for (ContentTemplateRef child : contentTemplateRef.getChildren()) {
            this.update(child);
        }
    }

    @Nonnull
    private ContentTemplateRefAo saveContentTemplateRef(@Nonnull ContentTemplateRef contentTemplateRef) {
        ContentTemplateRefAo parentAo = (ContentTemplateRefAo)this.contentTemplateRefManager.createAo(contentTemplateRef);
        for (ContentTemplateRef child : contentTemplateRef.getChildren()) {
            ContentTemplateRefAo childAo = this.saveContentTemplateRef(child);
            childAo.setParent(parentAo);
            childAo.save();
        }
        return parentAo;
    }
}

