/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.event.events.template.TemplateRemoveEvent;
import com.atlassian.confluence.event.events.template.TemplateUpdateEvent;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.services.PromotedTemplateService;
import com.atlassian.confluence.plugins.createcontent.services.TemplateUpdater;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import org.apache.commons.lang3.StringUtils;

public class TemplateUpdatedListener {
    private final TemplateUpdater templateUpdater;
    private final PromotedTemplateService promotedTemplateService;

    public TemplateUpdatedListener(TemplateUpdater templateUpdater, PromotedTemplateService promotedTemplateService) {
        this.templateUpdater = templateUpdater;
        this.promotedTemplateService = promotedTemplateService;
    }

    @EventListener
    public void onTempateUpdateEvent(TemplateUpdateEvent event) {
        PageTemplate newTemplate = event.getNewTemplate();
        PageTemplate oldTemplate = event.getOldTemplate();
        if (oldTemplate != null && oldTemplate.getId() == newTemplate.getId()) {
            return;
        }
        this.templateUpdater.updateContentTemplateRef(newTemplate);
    }

    @EventListener
    public void onTemplateRemoveEvent(TemplateRemoveEvent event) throws BlueprintIllegalArgumentException {
        PageTemplate template = event.getTemplate();
        Space space = template.getSpace();
        if (StringUtils.isBlank((CharSequence)template.getPluginKey()) && space != null) {
            this.promotedTemplateService.demoteTemplate(template.getId(), space.getKey());
        }
        this.templateUpdater.revertContentTemplateRef(template);
    }
}

