/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.factory;

import com.atlassian.confluence.api.impl.service.content.finder.AbstractFinder;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.template.ContentTemplateService;
import com.atlassian.confluence.api.service.finder.SingleFetcher;
import com.atlassian.confluence.plugins.createcontent.factory.FinderFactory;
import com.atlassian.confluence.plugins.createcontent.factory.TransactionWrappingFinder;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;

public class TemplateFinderFactory
implements FinderFactory {
    private final TransactionalHostContextAccessor hostContextAccessor;

    public TemplateFinderFactory(TransactionalHostContextAccessor hostContextAccessor) {
        this.hostContextAccessor = hostContextAccessor;
    }

    @Override
    public ContentTemplateService.TemplateFinder createFinder(ContentTemplateService service, Expansion ... expansions) {
        TemplateFinderImpl rawFinder = new TemplateFinderImpl(service, expansions);
        return new TransactionWrappingContentFinder(rawFinder, this.hostContextAccessor);
    }

    private static class TransactionWrappingContentFinder
    extends TransactionWrappingFinder<ContentTemplate>
    implements ContentTemplateService.TemplateFinder {
        private final TemplateFinderImpl delegate;

        public TransactionWrappingContentFinder(TemplateFinderImpl delegate, TransactionalHostContextAccessor hostContextAccessor) {
            super(delegate, delegate, hostContextAccessor);
            this.delegate = delegate;
        }

        public SingleFetcher<ContentTemplate> withId(ContentTemplateId contentTemplateId) {
            this.delegate.withId(contentTemplateId);
            return this;
        }

        public ContentTemplateService.ParameterTemplateFinder withType(ContentTemplateType contentTemplateType) {
            this.delegate.withType(contentTemplateType);
            return this;
        }

        public ContentTemplateService.ParameterTemplateFinder withSpace(Space space) {
            this.delegate.withSpace(space);
            return this;
        }
    }

    private class TemplateFinderImpl
    extends AbstractFinder<ContentTemplate>
    implements ContentTemplateService.TemplateFinder {
        private final ContentTemplateService contentTemplateService;
        private Option<Space> space;
        private ContentTemplateId contentTemplateId;
        private ContentTemplateType contentTemplateType;

        public TemplateFinderImpl(ContentTemplateService contentTemplateService, Expansion ... expansions) {
            super(expansions);
            this.space = Option.none();
            this.contentTemplateService = contentTemplateService;
        }

        public SingleFetcher<ContentTemplate> withId(ContentTemplateId contentTemplateId) {
            Preconditions.checkNotNull((Object)contentTemplateId);
            this.contentTemplateId = contentTemplateId;
            return this;
        }

        public ContentTemplateService.ParameterTemplateFinder withType(ContentTemplateType contentTemplateType) {
            Preconditions.checkNotNull((Object)contentTemplateType);
            this.contentTemplateType = contentTemplateType;
            return this;
        }

        public ContentTemplateService.ParameterTemplateFinder withSpace(Space space) {
            Preconditions.checkNotNull((Object)space);
            this.space = Option.some((Object)space);
            return this;
        }

        public PageResponse<ContentTemplate> fetchMany(PageRequest pageRequest) {
            return this.contentTemplateService.getTemplates(this.contentTemplateType, this.space, pageRequest, this.expansions);
        }

        public Option<ContentTemplate> fetchOne() {
            if (this.contentTemplateId != null) {
                return Option.option((Object)this.contentTemplateService.getTemplate(this.contentTemplateId, this.expansions));
            }
            ContentTemplate firstFound = (ContentTemplate)Iterables.first((Iterable)this.contentTemplateService.getTemplates(this.contentTemplateType, this.space, SimplePageRequest.ONE, this.expansions)).getOrNull();
            return Option.option((Object)firstFound);
        }
    }
}

