package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;

import javax.annotation.Nullable;
import java.util.Collection;

/**
 * Responsible for grouping <tt>PageTemplate</tt>s.
 */
public interface PageTemplateGrouper {
    /**
     * <p>Gets all blueprints available within the context. Please note, the blueprints may be
     * enabled or disabled in the context. </p>
     * <p>
     * <p>Filtering out enabled and disabled &lt;blueprint&gt;s are a separate concern.</p>
     *
     * @return a collection of blueprint entities.
     */
    Collection<ContentBlueprint> getSpaceContentBlueprints(@Nullable Space space);
}
