package com.atlassian.confluence.plugins.createcontent.spacecreationsteps;

import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;

import java.util.Map;

public class WatchSpaceCreationStep extends AbstractSpaceCreationStep {
    private final UserAccessor userAccessor;
    private final NotificationManager notificationManager;

    public static final String CONTEXT_KEY = "watchUsers";

    public WatchSpaceCreationStep(UserAccessor userAccessor, NotificationManager notificationManager) {
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
    }

    @Override
    public void posthandle(Space space, Map<String, Object> context) {
        final String users = (String) context.get(CONTEXT_KEY);
        if (users == null)
            return;

        final String[] split = users.split(",");
        for (String username : split) {
            final ConfluenceUser user = userAccessor.getUserByName(username);
            if (user != null) {
                notificationManager.addSpaceNotification(user, space);
            }
        }
    }
}
