package com.atlassian.confluence.plugins.createcontent.services.model;

import com.atlassian.confluence.plugins.createcontent.rest.entities.CreatePersonalSpaceRestEntity;
import com.atlassian.confluence.user.ConfluenceUser;

/**
 * A resolved {@link CreatePersonalSpaceRestEntity}.
 *
 * @since 2.0
 */
public class CreatePersonalSpaceRequest {
    private final ConfluenceUser spaceUser;
    private final String spacePermission;

    public CreatePersonalSpaceRequest(ConfluenceUser spaceUser, String spacePermission) {
        this.spaceUser = spaceUser;
        this.spacePermission = spacePermission;
    }

    public ConfluenceUser getSpaceUser() {
        return spaceUser;
    }

    public String getSpacePermission() {
        return spacePermission;
    }
}
