package com.atlassian.confluence.plugins.createcontent.services.model;

import com.atlassian.confluence.pages.Page;

/**
 * Represents a Confluence Page that has been created by a Blueprint. It has an index page!
 *
 * @since 2.0
 */
public class BlueprintPage {
    private final Page page;
    private final Page indexPage;

    public BlueprintPage(Page page, Page indexPage) {
        this.page = page;
        this.indexPage = indexPage;
    }

    public Page getPage() {
        return page;
    }

    public Page getIndexPage() {
        return indexPage;
    }
}
