package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintPage;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * An Entity that contains details of a Confluence page.
 */
public class PageEntity {
    @JsonProperty
    private long pageId;
    @JsonProperty
    private String title;
    @JsonProperty
    private String spaceKey;
    @JsonProperty
    private String url;
    @JsonProperty
    private PageEntity indexPage;
    @JsonProperty
    private String createSuccessRedirectUrl;

    public PageEntity() {
    }

    ;

    private PageEntity(Page page, String baseUrl) {
        pageId = page.getId();
        spaceKey = page.getSpaceKey();
        title = page.getTitle();
        url = baseUrl + page.getUrlPath();
        createSuccessRedirectUrl = url;
    }

    public PageEntity(BlueprintPage blueprintPage, String baseUrl) {
        this(blueprintPage.getPage(), baseUrl);
        if (blueprintPage.getIndexPage() != null)
            this.indexPage = new PageEntity(blueprintPage.getIndexPage(), baseUrl);
    }

    public long getPageId() {
        return pageId;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public String getTitle() {
        return title;
    }

    public String getUrl() {
        return url;
    }

    public PageEntity getIndexPage() {
        return indexPage;
    }

    public String getCreateSuccessRedirectUrl() {
        return createSuccessRedirectUrl;
    }

    public void setCreateSuccessRedirectUrl(String createSuccessRedirectUrl) {
        this.createSuccessRedirectUrl = createSuccessRedirectUrl;
    }
}
