package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizardEntity;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.UUID;

@XmlRootElement
public class CreateDialogWebItemEntity {
    @XmlElement
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private String styleClass;
    @XmlElement
    private String iconURL;
    @XmlElement
    private String itemModuleCompleteKey;
    @XmlElement
    private String blueprintModuleCompleteKey;
    @XmlElement
    private UUID contentBlueprintId;
    @XmlElement
    private String templateId;
    @XmlElement
    private String createResult;
    @XmlElement
    private String howToUseTemplate;
    @XmlElement
    private String directLink;
    @XmlElement
    private boolean skipHowToUse;
    @XmlElement
    private DialogWizardEntity wizard;
    @XmlElement
    private boolean isNew;
    @XmlElement
    private boolean isPromoted;

    // JAXB
    private CreateDialogWebItemEntity() {
    }

    public CreateDialogWebItemEntity(String name, String description, String styleClass, String iconURL,
                                     String templateId) {
        this.name = name;
        this.description = description;
        this.styleClass = styleClass;
        this.iconURL = iconURL;
        this.templateId = templateId;
    }

    public CreateDialogWebItemEntity(String name, String description, String styleClass, String iconURL,
                                     String itemModuleCompleteKey, UUID contentBlueprintId, String createResult, String howToUseTemplate,
                                     boolean skipHowToUse, DialogWizardEntity wizard) {
        this(name, description, styleClass, iconURL, itemModuleCompleteKey,
                contentBlueprintId, createResult, howToUseTemplate, null, skipHowToUse, wizard);
    }

    public CreateDialogWebItemEntity(String name, String description, String styleClass, String iconURL,
                                     String itemModuleCompleteKey, UUID contentBlueprintId, String createResult,
                                     String howToUseTemplate, String directLink,
                                     boolean skipHowToUse, DialogWizardEntity wizard) {
        this.name = name;
        this.description = description;
        this.styleClass = styleClass;
        this.iconURL = iconURL;
        this.itemModuleCompleteKey = itemModuleCompleteKey;
        this.contentBlueprintId = contentBlueprintId;
        this.createResult = createResult;
        this.howToUseTemplate = howToUseTemplate;
        this.directLink = directLink;
        this.wizard = wizard;
        this.skipHowToUse = skipHowToUse;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconURL() {
        return iconURL;
    }

    public void setIconURL(String iconURL) {
        this.iconURL = iconURL;
    }

    public String getItemModuleCompleteKey() {
        return itemModuleCompleteKey;
    }

    public void setItemModuleCompleteKey(String itemModuleCompleteKey) {
        this.itemModuleCompleteKey = itemModuleCompleteKey;
    }

    public String getBlueprintModuleCompleteKey() {
        return blueprintModuleCompleteKey;
    }

    public void setBlueprintModuleCompleteKey(final String blueprintModuleCompleteKey) {
        this.blueprintModuleCompleteKey = blueprintModuleCompleteKey;
    }

    public UUID getContentBlueprintId() {
        return contentBlueprintId;
    }

    public void setContentBlueprintId(UUID contentBlueprintId) {
        this.contentBlueprintId = contentBlueprintId;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getCreateResult() {
        return createResult;
    }

    public void setCreateResult(String createResult) {
        this.createResult = createResult;
    }

    public String getStyleClass() {
        return styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getHowToUseTemplate() {
        return howToUseTemplate;
    }

    public void setHowToUseTemplate(String howToUseTemplate) {
        this.howToUseTemplate = howToUseTemplate;
    }

    public String getDirectLink() {
        return directLink;
    }

    public void setDirectLink(String directLink) {
        this.directLink = directLink;
    }

    public boolean isSkipHowToUse() {
        return skipHowToUse;
    }

    public void setSkipHowToUse(boolean skipHowToUse) {
        this.skipHowToUse = skipHowToUse;
    }

    public DialogWizardEntity getWizard() {
        return wizard;
    }

    public void setWizard(final DialogWizardEntity wizard) {
        this.wizard = wizard;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public boolean isPromoted() {
        return isPromoted;
    }

    public void setPromoted(final boolean promoted) {
        isPromoted = promoted;
    }

    @Override
    public String toString() {
        // For debugging.
        return name + ", " + itemModuleCompleteKey;
    }
}
