package com.atlassian.confluence.plugins.createcontent.rest;

public class PageTemplateForm {
    public String name;
    public String description;

    /**
     * referencingPluginKey and referencingPluginModuleKey provide a mechanism for plugin modules to store customised
     * versions of templates declared in other plugins. For example 2 Blueprint modules might reference the same
     * template in another plugin but might each have their own user edited versions of the template.
     */
    public String referencingPluginKey;
    public String referencingModuleKey;

    /**
     * pluginKey and moduleKey provides a means to identify a PageTemplate declared in a plugin that has not
     * been persisted to the database (and hence does not yet have a database ID)
     */
    public String pluginKey;
    public String moduleKey;

    public String content;
    public String spaceKey;

    public long id;
    public int version;
}
