package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintDescriptor;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;

import java.util.List;

/**
 * Provides web-items to Content and Space Blueprint REST resources.
 */
public interface BlueprintWebItemService {
    List<CreateDialogWebItemEntity> getCreateSpaceWebItems(final I18NBean i18NBean, final DocumentationBean documentationBean, ConfluenceUser user);

    List<CreateDialogWebItemEntity> getCreateContentWebItems(final Space space, final I18NBean i18NBean,
                                                             final DocumentationBean documentationBean, ConfluenceUser user);


    List<WebItemModuleDescriptor> getCreateDialogWebItemModuleDescriptors(WebInterfaceContext context);

    @Deprecated
    BlueprintDescriptor getBlueprintDescriptorForWebItem(ModuleDescriptor webItem);

    // HACK! FIXME: This is a hack to get only the personal space web item. We need a way to use conditions to do this for us when calling webInterfaceManager.getDisplayableItems()
    List<CreateDialogWebItemEntity> getCreatePersonalSpaceWebItems(I18NBean i18NBean, DocumentationBean documentationBean, ConfluenceUser remoteUser);
}
