package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xwork.FlashScope;
import com.atlassian.event.api.EventListener;

import java.util.UUID;

/**
 * Listens for a BlueprintPageCreateevent and adds the key to the flash scope if this is the first time this kind of blueprint
 * has been created
 */
public class FirstBlueprintCreationListener {
    private final UserBlueprintConfigManager userBlueprintConfigManager;

    public FirstBlueprintCreationListener(final UserBlueprintConfigManager userBlueprintConfigManager) {
        this.userBlueprintConfigManager = userBlueprintConfigManager;
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null)
            return;  // don't show anonymous users the Index-page popup every time.

        UUID id = event.getBlueprint().getId();
        if (userBlueprintConfigManager.isFirstBlueprintOfTypeForUser(id, user)) {
            userBlueprintConfigManager.setBlueprintCreatedByUser(id, user);
            FlashScope.put(BlueprintManager.FIRST_BLUEPRINT_FOR_USER, id);
            FlashScope.put(BlueprintConstants.INDEX_DISABLED, event.getBlueprint().isIndexDisabled());
        }
    }
}
