package com.atlassian.confluence.plugins.createcontent.extensions;

import com.atlassian.confluence.user.ConfluenceUser;

import java.util.Set;
import java.util.UUID;

/**
 * Controls the the configuration of Blueprints for a User.
 *
 * @since 5.1
 */
public interface UserBlueprintConfigManager {
    /**
     * Return a set of Blueprint complete module keys for which the user does not wish to see the How-to-Use
     * dialog page.
     *
     * @param user a Confluence user to retrieve settings for
     * @return a set of Content Blueprint ids
     */
    Set<UUID> getSkipHowToUseKeys(ConfluenceUser user);

    /**
     * Sets the flag to skip the How-to-Use dialog page for a certain Blueprint and User.
     *
     * @param user               the user to skip the Blueprint for
     * @param contentBlueprintId the id for the Blueprint where How-to-Use should be skipped
     * @param skip               true if the How-to-Use should be skipped, false if shown
     */
    void setSkipHowToUse(ConfluenceUser user, UUID contentBlueprintId, boolean skip);

    /**
     * @param id   the id of the blueprint
     * @param user the user to check against
     * @return true if the user has not created a blueprint with the key before
     */
    boolean isFirstBlueprintOfTypeForUser(UUID id, ConfluenceUser user);

    /**
     * Flags that a Blueprint of a certain type has been created by a given user
     */
    void setBlueprintCreatedByUser(UUID id, ConfluenceUser user);
}
