package com.atlassian.confluence.plugins.createcontent.events;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;

import java.util.Map;

/**
 * Fired when a Page is created from a Blueprint.
 *
 * @since 5.0
 * @deprecated since 5.3. Use {@link com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent}
 */
@Deprecated
public class BlueprintPageCreateEvent extends PageEvent implements Created {
    private final ModuleCompleteKey blueprintKey;
    private final Map<String, Object> context;
    private final ConfluenceUser creator;
    private final ContentBlueprint blueprint;

    /**
     * @param src     the object that created the Blueprint Page
     * @param page    the Page created
     * @param creator the user that created the Blueprint
     * @param context the context in which the Blueprint page was created, including Wizard and Provider data.
     */
    public BlueprintPageCreateEvent(Object src, Page page, ContentBlueprint blueprint, ConfluenceUser creator,
                                    Map<String, Object> context) {
        super(src, page);
        this.blueprint = blueprint;
        this.blueprintKey = new ModuleCompleteKey(blueprint.getModuleCompleteKey());
        this.context = context;
        this.creator = creator;
    }

    /**
     * @deprecated Use {@link #getBlueprint()} and {@link com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint#getModuleCompleteKey()}
     */
    public ModuleCompleteKey getBlueprintKey() {
        return blueprintKey;
    }

    /**
     * @deprecated Uses wrong capitalisation. Use {@link #getBlueprintKey()} instead.
     */
    @Deprecated
    public ModuleCompleteKey getBluePrintKey() {
        return getBlueprintKey();

    }

    public Map<String, Object> getContext() {
        return context;
    }

    public ConfluenceUser getCreator() {
        return creator;
    }

    public ContentBlueprint getBlueprint() {
        return blueprint;
    }
}
