package com.atlassian.confluence.plugins.createcontent.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.security.PermissionManager;

import static com.atlassian.confluence.security.Permission.VIEW;
import static com.atlassian.confluence.security.PermissionManager.TARGET_APPLICATION;

/**
 * Passes if the current user has permission to use Confluence.
 *
 * @since 5.0
 */
public class UserCanUseConfluenceCondition extends BaseConfluenceCondition {
    private PermissionManager permissionManager;

    @Override
    protected boolean shouldDisplay(WebInterfaceContext context) {
        return permissionManager.hasPermission(context.getUser(), VIEW, TARGET_APPLICATION);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}
