package com.atlassian.confluence.plugins.createcontent.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.xwork.FlashScope;

/**
 * Condition for showing the blueprint index popup. True when the flash scope has the index we're looking for
 */
public class ShowBlueprintIndexPopupCondition extends BaseConfluenceCondition {
    @Override
    protected boolean shouldDisplay(final WebInterfaceContext webInterfaceContext) {
        return FlashScope.has(BlueprintManager.FIRST_BLUEPRINT_FOR_USER) &&
                (Boolean.TRUE != FlashScope.get(BlueprintConstants.INDEX_DISABLED));
    }
}
