package com.atlassian.confluence.plugins.createcontent.api.services;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.spaces.Space;

import javax.annotation.Nullable;

/**
 * Provides buttons that launch the Create dialog.
 */
@PublicApi
public interface CreateButtonService {
    /**
     * Render a button that launches the Create dialog for a Blueprint.
     * <p>
     * Depending on the Blueprint used, the contentBlueprintId or the blueprintModuleCompleteKey may be blank.
     *
     * @param space                      the space the new page will be created in
     * @param contentBlueprintId         the id of the Blueprint the new page will be created from
     * @param blueprintModuleCompleteKey the plugin module key of the Blueprint the new page will be created from
     * @param buttonLabelKey             (optional) the i18n key of the label for the Create button
     * @param newPageTitle               (optional) the i18ned title of the new page that will be created
     * @return rendered HTML for the button
     */
    String renderBlueprintButton(Space space, String contentBlueprintId, String blueprintModuleCompleteKey, @Nullable String buttonLabelKey, @Nullable String newPageTitle);

    /**
     * Render a button that launches the Create dialog for a Template.
     *
     * @param space          the space the new page will be created in
     * @param templateId     the id of the PageTemplate the new page will be created from
     * @param buttonLabelKey (optional) the i18n key of the label for the Create button
     * @param newPageTitle   (optional) the i18ned title of the new page that will be created
     * @return rendered HTML for the button
     */
    String renderTemplateButton(Space space, long templateId, @Nullable String buttonLabelKey, @Nullable String newPageTitle);
}
