package com.atlassian.confluence.plugins.createcontent.api.services;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.rest.entities.BlueprintPageEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintPage;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import com.atlassian.confluence.user.ConfluenceUser;

/**
 * Old interface to access DefaultContentBlueprintService
 *
 * @since 1.6
 * This interface expose too much Hibernate type, please use api ContentBlueprintService interface instead.
 */
@PublicApi
public interface ContentBlueprintService {
    /**
     * The key in the {@link BlueprintPageEntity} context specifying the title of the page or draft to be created.
     */
    String PAGE_TITLE = "title";
    String LABELS = "labelsString";

    /**
     * Creates a page from a Blueprint content template.
     *
     * @param createEntity defines the blueprint to create the page from, and the context
     * @param creator      user creating the page
     * @return the created BlueprintPage
     */
    BlueprintPage createPage(CreateBlueprintPageEntity createEntity, ConfluenceUser creator) throws BlueprintIllegalArgumentException;

    /**
     * Creates a per-user page draft from a Blueprint content template.
     *
     * @param createEntity defines the blueprint to create the draft from, and the context
     * @param creator      user creating the page
     * @return the created Draft
     * @deprecated since 5.9
     */
    @Deprecated
    Draft createDraft(CreateBlueprintPageEntity createEntity, ConfluenceUser creator) throws BlueprintIllegalArgumentException;

    /**
     * Create a page draft from a Blueprint content template. This will create a per-page draft if the feature is enabled
     * (see {@link com.atlassian.confluence.core.ContentEntityObject#DRAFT}) or a per-user {@link com.atlassian.confluence.pages.Draft} otherwise.
     *
     * @param createEntity defines the blueprint to create the draft from, and the context
     * @param creator      user creating the page
     * @return the created draft
     * @throws BlueprintIllegalArgumentException exception
     * @since 5.9
     */
    ContentEntityObject createContentDraft(CreateBlueprintPageEntity createEntity, ConfluenceUser creator) throws BlueprintIllegalArgumentException;
}
