package com.atlassian.confluence.plugins.createcontent.api.exceptions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Exception that's thrown when content is being created with illegal arguments for the Blueprint it's being created from.
 */
public class BlueprintIllegalArgumentException extends AbstractTypedException {
    public BlueprintIllegalArgumentException(@Nonnull final String message, final @Nonnull ResourceErrorType errorType) {
        this(message, errorType, null);
    }

    public BlueprintIllegalArgumentException(@Nonnull final String message, final @Nonnull ResourceErrorType errorType, @Nullable Object errorData) {
        super(message, errorType, errorData);
    }
}
