package com.atlassian.confluence.plugins.createcontent.activeobjects;

import com.atlassian.confluence.plugins.createcontent.extensions.SpaceBlueprintModuleDescriptor;
import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;
import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.StringLength;

import javax.annotation.Nullable;
import java.io.Serializable;

/**
 * Describes a Space Blueprint. The interface common to {@link SpaceBlueprintModuleDescriptor} and
 * {@link SpaceBlueprint}.
 *
 * @since 1.6
 */
@Preload
public interface SpaceBlueprintAo extends Entity, Serializable, PluginBackedBlueprintAo {
    /**
     * Set the ContentTemplateRef that will be used to create the homepage of the space
     */
    void setHomePage(ContentTemplateRefAo homePageTemplateRef);

    /**
     * Space label AKA category of the space.
     * The category is an optional field.
     */
    String getCategory();

    void setCategory(String category);

    /**
     * Get the ContentTemplateRef that will be used to create the homepage of the space. May be null if this
     * Space Blueprint doesn't specify a custom home page.
     */
    @Nullable
    ContentTemplateRefAo getHomePage();

    @StringLength(value = StringLength.UNLIMITED)
    void setPromotedBps(String promotedBps);

    String getPromotedBps();
}
