package com.atlassian.confluence.plugins.createcontent.activeobjects;

import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.schema.Table;

import java.io.Serializable;

@Preload
@Table("C_TEMPLATE_REF")
public interface ContentTemplateRefAo extends Serializable, PluginBackedBlueprintAo {
    long getTemplateId();

    void setTemplateId(long templateId);

    @Accessor("CB_PARENT")
        // When this ContentTemplateRef is representing a normal template
    ContentBlueprintAo getContentBlueprintParent();

    @Mutator("CB_PARENT")
    void setContentBlueprintParent(ContentBlueprintAo parent);

    @Accessor("CB_INDEX_PARENT")
        // When this ContentTemplateRef is representing an index page
    ContentBlueprintAo getContentBlueprintIndexParent();

    @Mutator("CB_INDEX_PARENT")
    void setContentBlueprintIndexParent(ContentBlueprintAo bp);

    ContentTemplateRefAo getParent();

    void setParent(ContentTemplateRefAo parent);

    /**
     * Return the child ContentTemplate refs that this Template has.
     */
    @OneToMany(reverse = "getParent")
    ContentTemplateRefAo[] getChildTemplateRefs();
}
