package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PluginTemplateReference;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageRequest;
import com.atlassian.confluence.spaces.Space;

import java.util.Map;

/**
 * Responsible for generating content for created blueprint pages.
 */
public interface BlueprintContentGenerator {
    /**
     * Creates an unsaved content page object given a plugin template and a render context.
     */
    @Deprecated
    Page generateBlueprintPageObject(PluginTemplateReference pluginTemplateReference, Map<String, ? extends Object> context);

    /**
     * Creates an index page object given a plugin template and a render context.
     */
    @Deprecated
    Page createIndexPageObject(PluginTemplateReference pluginTemplateReference, Map<String, Object> context);

    Page createIndexPageObject(ContentTemplateRef contentTemplateRef, Space space, Map<String, Object> context);

    @Deprecated
    Page generateBlueprintPageObject(ContentTemplateRef contentTemplateRef, Space space, Map<String, Object> context);

    /**
     * Creates an unsaved content page object for a create-Blueprint-page request.
     */
    Page generateBlueprintPageObject(CreateBlueprintPageRequest createRequest);
}