package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleCompleteKey;

import java.util.Map;

/**
 * Fired when a Page is created from a Blueprint.
 *
 * @since 5.0
 */
public class TemplatePageCreateEvent extends PageEvent implements Created {
    private final ModuleCompleteKey completeKey;
    private final Map<String, Object> context;
    private final ConfluenceUser user;
    private final ContentTemplateRef templateRef;
    private final SaveContext saveContext;

    /**
     * @param src     the object that created the Blueprint Page
     * @param page    the Page created
     * @param user    the user that created the Blueprint
     * @param context the context in which the Blueprint page was created, including Wizard and Provider data.
     *
     * @deprecated
     */
    @Deprecated
    public TemplatePageCreateEvent(Object src, Page page, ContentTemplateRef templateRef, ConfluenceUser user,
                                   Map<String, Object> context) {
       this(src, page, templateRef, user, context, DefaultSaveContext.DEFAULT) ;
    }

    /**
     * @param src     the object that created the Blueprint Page
     * @param page    the Page created
     * @param user    the user that created the Blueprint
     * @param context the context in which the Blueprint page was created, including Wizard and Provider data.
     * @param saveContext the saveContext to use when saving the relevant page
     */
    public TemplatePageCreateEvent(final Object src,
                                   final Page page,
                                   final ContentTemplateRef templateRef,
                                   final ConfluenceUser user,
                                   final Map<String, Object> context,
                                   final SaveContext saveContext) {
        super(src, page, false);
        this.templateRef = templateRef;
        this.completeKey = templateRef.getModuleCompleteKey() == null ? null : new ModuleCompleteKey(templateRef.getModuleCompleteKey());
        this.context = context;
        this.user = user;
        this.saveContext = saveContext;
    }

    /**
     * @deprecated Use {@link #getTemplateRef()} and {@link com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint#getModuleCompleteKey()}
     */
    public ModuleCompleteKey getTemplateKey() {
        return completeKey;
    }

    public Map<String, Object> getContext() {
        return context;
    }

    public ConfluenceUser getUser() {
        return user;
    }

    public ContentTemplateRef getTemplateRef() {
        return templateRef;
    }

    public SaveContext getSaveContext() {
        return saveContext;
    }
}
