package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftsTransitionHelper;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * An Entity that contains details of a Confluence page draft.
 * <p>
 * Should join forces with PageEntity in the fight for DRY code.
 */
@XmlRootElement
public class BlueprintDraftEntity {
    @XmlElement
    private long draftId;
    @XmlElement
    private String title;
    @XmlElement
    private String spaceKey;
    @XmlElement
    private String url;

    public BlueprintDraftEntity() {
    }

    /**
     * @deprecated since 5.9
     */
    @Deprecated
    public BlueprintDraftEntity(final Draft draft, String baseUrl) {
        this((ContentEntityObject) draft, baseUrl);
    }

    public BlueprintDraftEntity(final ContentEntityObject contentDraft, String baseUrl) {
        draftId = contentDraft.getId();
        spaceKey = DraftsTransitionHelper.getSpaceKey(contentDraft);
        title = contentDraft.getTitle();
        url = baseUrl + String.format("/plugins/createcontent/draft-createpage.action?draftId=%s", draftId);
    }

    public long getDraftId() {
        return draftId;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public String getTitle() {
        return title;
    }

    public String getUrl() {
        return url;
    }
}
