package com.atlassian.confluence.plugins.createcontent.model;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.ModuleCompleteKey;

import java.util.UUID;

/**
 * Represents a bundle of identifying information for a ContentBlueprint.
 * <p>
 * Blueprints have UUIDs, but when attempting to resolve the correct Blueprint for a given context, more information
 * like the Blueprint's plugin module key (if present) and the context's Space may be required.
 * <p>
 * This objects saves the resolver-interface from needing to accept a number of different arguments in various
 * overloaded methods.
 *
 * @since 2.1
 */
public class BlueprintIdBundle {
    private final UUID blueprintId;
    private final ModuleCompleteKey blueprintModuleKey;
    private final String spaceKey;
    private final Space space;

    public BlueprintIdBundle(UUID blueprintId, ModuleCompleteKey blueprintModuleKey, Space space) {
        this.blueprintId = blueprintId;
        this.blueprintModuleKey = blueprintModuleKey;
        this.space = space;
        this.spaceKey = space.getKey();
    }

    /**
     * The calling code shouldn't need to resolve a Space from a spaceKey if it doesn't need to. Only the resolver that
     * the bundle is passed to knows if the Space will be needed, so it can resolve it at that end.
     */
    public BlueprintIdBundle(UUID blueprintId, ModuleCompleteKey blueprintModuleKey, String spaceKey) {
        this.blueprintId = blueprintId;
        this.blueprintModuleKey = blueprintModuleKey;
        this.spaceKey = spaceKey;
        this.space = null;
    }

    public UUID getBlueprintId() {
        return blueprintId;
    }

    public ModuleCompleteKey getBlueprintModuleKey() {
        return blueprintModuleKey;
    }

    public Space getSpace() {
        return space;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    @Override
    public String toString() {
        return "Blueprint id: " + blueprintId + ", module key: " + blueprintModuleKey + ", space: " + space;
    }
}
