package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.plugins.createcontent.activeobjects.SpaceBlueprintAo;
import com.atlassian.confluence.plugins.createcontent.rest.ModuleCompleteKeyDeserializer;
import com.atlassian.confluence.plugins.createcontent.rest.ModuleCompleteKeySerializer;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;
import com.atlassian.plugin.ModuleCompleteKey;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.UUID;

/**
 * A Blueprint for creating a Space. Instances of this class should be transformed to a {@link SpaceBlueprintAo} for persistence.
 *
 * @since 1.7
 */
@XmlRootElement
public class SpaceBlueprint extends PluginBackedBlueprint {
    private UUID homePageId;   // ContentBlueprint DB id, may be null if the Space will use the default homepage
    private DialogWizard dialogWizard;
    private List<ModuleCompleteKey> promotedBps;
    private String category;

    // JAXB
    private SpaceBlueprint() {
    }

    public SpaceBlueprint(UUID id, String moduleCompleteKey, String i18nNameKey, boolean pluginClone,
                          List<ModuleCompleteKey> promotedBps, @Nullable DialogWizard dialogWizard,
                          String category) {
        super(id, moduleCompleteKey, i18nNameKey, pluginClone);
        this.promotedBps = promotedBps;
        this.dialogWizard = dialogWizard;
        this.category = category;
    }

    @Nullable
    @XmlElement
    public UUID getHomePageId() {
        return homePageId;
    }

    @Nullable
    @XmlElement
    public DialogWizard getDialogWizard() {
        return dialogWizard;
    }

    @XmlElement
    @JsonSerialize(contentUsing = ModuleCompleteKeySerializer.class)
    @JsonDeserialize(contentUsing = ModuleCompleteKeyDeserializer.class)
    public List<ModuleCompleteKey> getPromotedBps() {
        return promotedBps;
    }

    @Nullable
    @XmlElement
    public String getCategory() {
        return category;
    }

    // Setters

    public void setHomePageId(UUID homePageId) {
        this.homePageId = homePageId;
    }

    public void setPromotedBps(final List<ModuleCompleteKey> promotedBps) {
        this.promotedBps = promotedBps;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}
