package com.atlassian.confluence.plugins.createcontent.impl;

import javax.xml.bind.annotation.XmlElement;
import java.util.UUID;

// FIXME: This name is confusing. We use this class for different parts of blueprints besides blueprints themselves
public abstract class PluginBackedBlueprint extends UuidBacked {
    private String moduleCompleteKey;
    private String i18nNameKey;
    private boolean pluginClone;

    protected PluginBackedBlueprint() {
    }

    protected PluginBackedBlueprint(UUID id, String moduleCompleteKey, String i18nNameKey, boolean pluginClone) {
        super(id);
        this.moduleCompleteKey = moduleCompleteKey;
        this.i18nNameKey = i18nNameKey;
        this.pluginClone = pluginClone;
    }

    // Getters

    @XmlElement
    public String getModuleCompleteKey() {
        return moduleCompleteKey;
    }

    @XmlElement
    public String getI18nNameKey() {
        return i18nNameKey;
    }

    @XmlElement
    public boolean isPluginClone() {
        return pluginClone;
    }

    // Setters

    public void setModuleCompleteKey(String moduleCompleteKey) {
        this.moduleCompleteKey = moduleCompleteKey;
    }

    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    public void setPluginClone(boolean pluginClone) {
        this.pluginClone = pluginClone;
    }
}
