package com.atlassian.confluence.plugins.createcontent.extensions;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;
import com.atlassian.plugin.ModuleCompleteKey;

import java.util.List;

public interface BlueprintDescriptor {
    /**
     * @deprecated since 1.3.11 Use {@link #getFirstContentTemplateKey()}.
     */
    @Deprecated
    ModuleCompleteKey getContentTemplateKey();

    /**
     * Replaces the deprecated {@link #getContentTemplateKey} method, returning the first defined content-template-key
     * for this Blueprint.
     */
    ModuleCompleteKey getFirstContentTemplateKey();

    /**
     * Return the keys of the {@link PageTemplate}s associated with this Blueprint.
     */
    List<ModuleCompleteKey> getContentTemplates();

    /**
     * Return a ModuleCompleteKey with this Blueprint plugin's key and the moduleKey specified.
     */
    ModuleCompleteKey getContentTemplateKey(String contentTemplateModuleKey);

    ModuleCompleteKey getIndexTemplate();

    ModuleCompleteKey getBlueprintKey();

    String getIndexKey();

    String getCreateResult();

    String getIndexTitleI18nKey();

    String getHowToUseTemplate();

    DialogWizard getDialogWizard();

    boolean isIndexDisabled();
}
