package com.atlassian.confluence.plugins.createcontent.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.User;

/**
 * Condition for showing the welcome to spaces dialog. True when the user clicks on the create space button for the first time.
 */
public class ShowSpaceWelcomeDialogCondition extends BaseConfluenceCondition {
    public static final String SPACE_WELCOME_DIALOG_DISMISSED_KEY = "confluence.user.create.content.space.welcome.dialog.dismissed";

    private final UserAccessor userAccessor;

    public ShowSpaceWelcomeDialogCondition(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    protected boolean shouldDisplay(final WebInterfaceContext context) {
        User user = (User) context.getParameter("remoteuser");
        // Do not show for anonymous users
        if (user == null) {
            return false;
        }

        final UserPreferences pref = userAccessor.getUserPreferences(user);
        if (pref == null) {
            return false;
        }

        return !pref.getBoolean(SPACE_WELCOME_DIALOG_DISMISSED_KEY);
    }
}
