package com.atlassian.confluence.plugins.createcontent.api.services;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreatePersonalSpaceRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintSpace;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintSpaceEntity;
import com.atlassian.confluence.user.ConfluenceUser;

/**
 * Creates spaces from Space Blueprints.
 *
 * @since 5.3
 */
@PublicApi
public interface SpaceBlueprintService {
    /**
     * Creates a Space from the given request details and Blueprint key, and returns the created Space.
     *
     * @return the created Space
     */
    BlueprintSpace createSpace(CreateBlueprintSpaceEntity entity, ConfluenceUser creator)
            throws BlueprintIllegalArgumentException;

    BlueprintSpace createPersonalSpace(CreatePersonalSpaceRestEntity entity, ConfluenceUser creator);
}
