package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.xwork.FlashScope;
import com.google.common.collect.Maps;
import com.opensymphony.webwork.ServletActionContext;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.CREATE_DIALOG_INIT_PARAMS_KEY;

/**
 * This action enables the create dialog to be triggered with some initialisation parameters, by putting
 * all parameters from the request into the flash scope and then redirecting to the Confluence dashboard
 * with the additional query parameter "createDialog=true", which triggers the create dialog to be launched.
 * <p>
 * The parameters in flash scope are retrieved and rendered as part of the create-dialog-init-params web-panel,
 * which uses hidden div elements to make these parameters available to the client-side create dialog JavaScript.
 */
public class InitCreateDialogAction extends ConfluenceActionSupport {
    @Override
    public String execute() throws Exception {
        FlashScope.put(CREATE_DIALOG_INIT_PARAMS_KEY, Maps.newHashMap(ServletActionContext.getRequest().getParameterMap()));
        return super.execute();
    }
}
