package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.core.user.preferences.UserPreferences;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;

public class BPUserPreferences extends UserPreferences {
    private final PropertySet propertySet;

    public BPUserPreferences(PropertySet propertySet) {
        super(propertySet);
        this.propertySet = propertySet;
    }

    public void setText(String key, String value) throws PropertyException {
        propertySet.setText(key, value);
    }

    public String getText(String key) throws PropertyException {
        return propertySet.getText(key);
    }
}
