package com.atlassian.confluence.plugins.createcontent.services.model;

import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;

import java.util.Map;

/**
 * A resolved/validated request to create a Confluence Space from a Blueprint.
 *
 * @since 2.0
 */
public class CreateBlueprintSpaceRequest {
    private final SpaceBlueprint blueprint;
    private String spaceKey;
    private String name;
    private String description;
    private Map<String, Object> context;

    public CreateBlueprintSpaceRequest(SpaceBlueprint blueprint, CreateBlueprintSpaceEntity entity) {
        this.blueprint = blueprint;
        this.spaceKey = entity.getSpaceKey();
        this.name = entity.getName();
        this.description = entity.getDescription();
        this.context = entity.getContext();
    }

    public SpaceBlueprint getBlueprint() {
        return blueprint;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public Map<String, Object> getContext() {
        return context;
    }
}
