package com.atlassian.confluence.plugins.createcontent.rest.entities;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Information required in a call to create a Personal space.
 *
 * @since 2.0
 */
public class CreatePersonalSpaceRestEntity {
    @JsonProperty
    private final String spaceUserKey;
    @JsonProperty
    private final String spacePermission;

    @JsonCreator
    public CreatePersonalSpaceRestEntity(
            @JsonProperty("spaceUserKey") String spaceUserKey,
            @JsonProperty("spacePermission") String spacePermission) {
        this.spaceUserKey = spaceUserKey;
        this.spacePermission = spacePermission;
    }

    /**
     * @return the user-key of the user that the space will be created for.
     */
    public String getSpaceUserKey() {
        return spaceUserKey;
    }

    /**
     * @return true if the created space should be private
     */
    public String isSpacePermission() {
        return spacePermission;
    }
}
