package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.plugin.ModuleCompleteKey;

/**
 * Helps with ModuleCompleteKeys, those sneaky things.
 *
 * @since 2.0
 */
public class ModuleCompleteKeyUtils {
    /**
     * Return a complete module key given the supplied plugin key and module key. The trick here is that the module
     * key may be relative (i.e. a normal module key) or a complete key itself, in which case it should be returned as
     * is.
     *
     * @param pluginKey a fall-back plugin key in case the module key is actually "relative"
     * @param moduleKey a plugin module key that be relative or complete
     * @return a complete key
     */
    public static ModuleCompleteKey getModuleCompleteKeyFromRelative(String pluginKey, String moduleKey) {
        try {
            return new ModuleCompleteKey(moduleKey);
        } catch (Exception e) {
            return new ModuleCompleteKey(pluginKey, moduleKey);
        }
    }
}
